<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');


include("../rs.php");


$admin_email = isset($_POST['admin_email']) ? trim($_POST['admin_email']) : '';
$admin_password = isset($_POST['admin_password']) ? trim($_POST['admin_password']) : '';
$user_email = isset($_POST['user_email']) ? trim($_POST['user_email']) : '';
$user_password = isset($_POST['user_password']) ? trim($_POST['user_password']) : '';
$user_did = isset($_POST['user_did']) ? trim($_POST['user_did']) : '';
$action = isset($_POST['action']) ? trim($_POST['action']) : '';
$value = isset($_POST['value']) ? trim($_POST['value']) : '';


if (empty($admin_email) || empty($admin_password) || empty($user_email) || empty($user_password) || empty($user_did) || empty($action)) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}

$admin_stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$admin_stmt->bind_param("ss", $admin_email, $admin_password);
$admin_stmt->execute();
$admin_result = $admin_stmt->get_result();

if ($admin_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $admin_stmt->close();
    $conn->close();
    exit();
}
$admin_stmt->close();

$user_check_stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND password = ? AND device_id = ?");
$user_check_stmt->bind_param("sss", $user_email, $user_password, $user_did);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows === 0) {
    http_response_code(404);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $user_check_stmt->close();
    $conn->close();
    exit();
}
$user_check_stmt->close();

if ($action === 'account_status') {

    if ($value === '') {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
        exit();
    }
    
    if ($value === 'Ban') {
    
            $update_stmt = $conn->prepare("UPDATE users SET `status` = 'Ban' WHERE email = ? AND password = ?");
        $update_stmt->bind_param("ss", $user_email, $user_password);

        if ($update_stmt->execute()) {
           
            echo json_encode([
                "status" => "success",
                "message" => "Ban Success"
            ], JSON_PRETTY_PRINT);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Access Denied"
            ], JSON_PRETTY_PRINT);
        }
        $update_stmt->close();
    
    }
    
    if ($value === 'Unban') {
    
            $update_stmt = $conn->prepare("UPDATE users SET `status` = 'Unban' WHERE email = ? AND password = ?");
        $update_stmt->bind_param("ss", $user_email, $user_password);

        if ($update_stmt->execute()) {
           
            echo json_encode([
                "status" => "success",
                "message" => "Unban Success"
            ], JSON_PRETTY_PRINT);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Access Denied"
            ], JSON_PRETTY_PRINT);
        }
        $update_stmt->close();
 }
    

} else {

  
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
}

$conn->close();

?>
