<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');


include("../rs.php");

$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$stmt_admin = $conn->prepare("SELECT * FROM `admins` WHERE email = ? AND password = ?");
$stmt_admin->bind_param("ss", $email, $password);
$stmt_admin->execute();
$result_admin = $stmt_admin->get_result();

if ($result_admin->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}


$sql_users = "SELECT COUNT(*) as total_users, SUM(winning + balance) as total_points FROM users";
$result_users = $conn->query($sql_users);
$users_data = $result_users->fetch_assoc();


$sql_sms = "SELECT COUNT(*) as pending_sms FROM rs_sms WHERE status = 'pending'";
$result_sms = $conn->query($sql_sms);
$sms_data = $result_sms->fetch_assoc();


$sql_withdraw = "SELECT COUNT(*) as pending_withdraw FROM tranx WHERE type = 'Withdraw' AND status = 'Pending'";
$result_withdraw = $conn->query($sql_withdraw);
$withdraw_data = $result_withdraw->fetch_assoc();

$categories = [
        "BATTLE ROYAL",
        "CLASH SQUAD",
        "LONE WOLF",
        "CSV2",
        "LUDO",
        "FREE MATCH"
];

$match_counts = [];

foreach ($categories as $category) {
    $stmt_match = $conn->prepare("SELECT COUNT(*) as count FROM `match` WHERE `status` = 'Match' AND `match_type` = ?");
    $stmt_match->bind_param("s", $category);
    $stmt_match->execute();
    $result_match = $stmt_match->get_result();
    $row = $result_match->fetch_assoc();

    $match_counts[$category] = strval(intval($row['count']));
}


$response = array_merge([
    "total_users" => strval($users_data['total_users']),
    "total_balance" => strval($users_data['total_points']),
    "pending_sms" => strval($sms_data['pending_sms']),
    "pending_withdraw" => strval($withdraw_data['pending_withdraw'])
], $match_counts);

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

$conn->close();

?>
