<?php
include("../rs.php");

if (!isset($_POST['email'], $_POST['password'], $_POST['matchkey'])) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}

$admin_email = $_POST['email'];
$admin_password = $_POST['password'];
$matchkey = $_POST['matchkey'];

$user_check_sql = "SELECT 1 FROM admins WHERE email = ? AND password = ?";
$user_check_stmt = $conn->prepare($user_check_sql);
$user_check_stmt->bind_param("ss", $admin_email, $admin_password);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}


$matchTypeQuery = "SELECT `status` FROM `match` WHERE matchkey = ?";
$typeStmt = $conn->prepare($matchTypeQuery);
$typeStmt->bind_param("s", $matchkey);
$typeStmt->execute();
$typeResult = $typeStmt->get_result();

if ($typeResult->num_rows > 0) {
    $typeRow = $typeResult->fetch_assoc();
    $matchType = $typeRow['status'];

    if ($matchType == 'Match') {
       
        $sql = "SELECT `email`, `password`, `entry_fees` FROM `match_history` WHERE match_key = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $matchkey);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $participants = $result->fetch_all(MYSQLI_ASSOC);

            foreach ($participants as $participant) {
                $email = $participant['email'];
                $password = $participant['password'];
                $entry_fees = $participant['entry_fees'];

                
                $updateBalance = "UPDATE `users` SET `balance` = `balance` + ? WHERE `email` = ? AND `password` = ?";
                $balanceStmt = $conn->prepare($updateBalance);
                $balanceStmt->bind_param("dss", $entry_fees, $email, $password);
                $balanceStmt->execute();
            }
        }
    }

    
    $deleteMatch = "DELETE FROM `match` WHERE matchkey = ?";
    $deleteStmt = $conn->prepare($deleteMatch);
    $deleteStmt->bind_param("s", $matchkey);

    if ($deleteStmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Match Delete Successfully"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Access Denied"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Access Denied"]);
}

$conn->close();
?>