<?php
header('Content-Type: application/json; charset=UTF-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");

$required = [
    'email', 'password', 'title', 'time', 'date', 'perkill', 'ef', 'et',
    'total_players', 'tp', 'match_type', 'map', 'pd', 'v'
];

foreach ($required as $field) {
    if (!isset($_POST[$field])) {
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        exit();
    }
}

$admin_email = $_POST['email'];
$admin_pass  = $_POST['password'];

$check_admin = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$check_admin->bind_param("ss", $admin_email, $admin_pass);
$check_admin->execute();
$result = $check_admin->get_result();

if ($result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    exit();
}

$check_admin->close();

$title           = $_POST['title'];
$time            = $_POST['time'];
$date            = $_POST['date'];
$perkill         = $_POST['perkill'];
$ef              = $_POST['ef'];
$et              = $_POST['et'];
$total_players   = $_POST['total_players'];
$tp              = $_POST['tp'];
$match_type      = $_POST['match_type'];
$map             = $_POST['map'];
$pd              = $_POST['pd'];
$v               = $_POST['v'];
$matchkey        = strtoupper(bin2hex(random_bytes(8)));

$stmt = $conn->prepare("
    INSERT INTO `match` 
    (`title`, `time`, `date`, `perkill`, `ef`, `et`, `total_players`, `tp`, `match_type`, `map`, `pd`, `v`, `matchkey`)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "sssssssssssss",
    $title, $time, $date, $perkill, $ef, $et, $total_players, $tp,
    $match_type, $map, $pd, $v, $matchkey
);

if ($stmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "Match Added Successfully"
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
}

$stmt->close();
$conn->close();
?>