<?php
header('Content-Type: application/json; charset=UTF-8');

include ("../rs.php");

$admin_email = $_POST['admin_email'];
$admin_password = $_POST['admin_password'];
$user_email = $_POST['user_email'];
$user_password = $_POST['user_password'];
$transaction_id = $_POST['transaction_id'];
$action = $_POST['action'];

$admin_stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$admin_stmt->bind_param("ss", $admin_email, $admin_password);
$admin_stmt->execute();
$admin_result = $admin_stmt->get_result();

if ($admin_result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    $admin_stmt->close();
    $conn->close();
    exit;
}

$user_stmt = $conn->prepare("SELECT name, winning, fcm_key FROM users WHERE email = ? AND password = ?");
$user_stmt->bind_param("ss", $user_email, $user_password);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if ($user_result->num_rows === 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
    $user_stmt->close();
    $conn->close();
    exit;
}

$user_data = $user_result->fetch_assoc();
$rs_name = $user_data['name'];
$current_wallet = $user_data['winning'];
$rs_fcm_key = $user_data['fcm_key'];

if ($action == 'success') {

    $update_stmt = $conn->prepare("UPDATE tranx SET status = 'Success' WHERE tranx = ? AND email = ? AND password = ? AND status = 'Pending'");
    $update_stmt->bind_param("sss", $transaction_id, $user_email, $user_password);
    if ($update_stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Transaction Success", "action" => $action, "fcm_key" => $rs_fcm_key, "name" => $rs_name], JSON_PRETTY_PRINT);
    } else {
        echo json_encode(["status" => "error", "message" => "Transaction Failed"], JSON_PRETTY_PRINT);
    }
    $update_stmt->close();
} elseif ($action == 'cancel') {

    $tranx_stmt = $conn->prepare("SELECT amount FROM tranx WHERE tranx = ? AND email = ? AND password = ? AND status = 'Pending'");
    $tranx_stmt->bind_param("sss", $transaction_id, $user_email, $user_password);
    $tranx_stmt->execute();
    $tranx_result = $tranx_stmt->get_result();

    if ($tranx_result->num_rows === 0) {
        echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
        $tranx_stmt->close();
        $conn->close();
        exit;
    }

    $tranx_data = $tranx_result->fetch_assoc();
    $amount = $tranx_data['amount'];
    $tranx_stmt->close();

    $new_wallet = $current_wallet + $amount;
    $wallet_stmt = $conn->prepare("UPDATE users SET `winning` = ? WHERE email = ? AND password = ?");
    $wallet_stmt->bind_param("dss", $new_wallet, $user_email, $user_password);
    $wallet_stmt->execute();
    $wallet_stmt->close();

    $cancel_stmt = $conn->prepare("UPDATE tranx SET status = 'Cancel' WHERE tranx = ? AND email = ? AND password = ? AND status = 'Pending'");
    $cancel_stmt->bind_param("sss", $transaction_id, $user_email, $user_password);
    if ($cancel_stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Cancelled Success", "action" => $action, "fcm_key" => $rs_fcm_key, "name" => $rs_name], JSON_PRETTY_PRINT);
    } else {
        echo json_encode(["status" => "error", "message" => "Canceled Failed"], JSON_PRETTY_PRINT);
    }
    $cancel_stmt->close();
} else {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT);
}

$user_stmt->close();
$admin_stmt->close();
$conn->close();
?>
