<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
include("../rs.php");

$email    = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';

if (empty($email) || empty($password)) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$stmt_admin = $conn->prepare("SELECT 1 FROM `admins` WHERE email = ? AND password = ?");
$stmt_admin->bind_param("ss", $email, $password);
$stmt_admin->execute();
$result_admin = $stmt_admin->get_result();

if ($result_admin->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $stmt_admin->close();
    $conn->close();
    exit;
}
$stmt_admin->close();

$stmt_rules = $conn->prepare("SELECT * FROM `rules` LIMIT 1");
$stmt_rules->execute();
$result_rules = $stmt_rules->get_result();

if ($result_rules->num_rows > 0) {
    $data = $result_rules->fetch_assoc();
    echo json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    http_response_code(404);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$stmt_rules->close();
$conn->close();
?>