<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
include("../rs.php");

$email    = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$bKash = $_POST['bKash'] ?? '';
$NAGAD  = $_POST['NAGAD'] ?? '';
$Rocket    = $_POST['Rocket'] ?? '';
$min_deposit         = $_POST['min_deposit'] ?? '';
$min_withdraw         = $_POST['min_withdraw'] ?? '';
$notice   = $_POST['notice'] ?? '';
$support_link    = $_POST['support_link'] ?? '';
$deposit_link = $_POST['deposit_link'] ?? '';
$room_link = $_POST['room_link'] ?? '';
$join_link  = $_POST['join_link'] ?? '';
$vc    = $_POST['vc'] ?? '';
$update_link         = $_POST['update_link'] ?? '';
$update_date         = $_POST['update_date'] ?? '';
$update_notice   = $_POST['update_notice'] ?? '';
$close_notice    = $_POST['close_notice'] ?? '';
$app_status = $_POST['app_status'] ?? '';
$rs_action = $_POST['rs_action'] ?? '';


if (empty($email) || empty($password)) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit;
}

$stmt_admin = $conn->prepare("SELECT 1 FROM `admins` WHERE email = ? AND password = ?");
$stmt_admin->bind_param("ss", $email, $password);
$stmt_admin->execute();
$result_admin = $stmt_admin->get_result();

if ($result_admin->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $stmt_admin->close();
    $conn->close();
    exit;
}
$stmt_admin->close();

 if($rs_action == 'rs_number') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET bKash = ?, NAGAD = ?, Rocket = ?
    LIMIT 1
");
$stmt_update->bind_param("sss", $bKash, $NAGAD, $Rocket);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "Number Update Successfully"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }
 
 if($rs_action == 'rs_min_value') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET min_deposit = ?, min_withdraw = ?, notice = ?
    LIMIT 1
");
$stmt_update->bind_param("sss", $min_deposit, $min_withdraw, $notice);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "Settings Update Successfully"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }
 
 if($rs_action == 'rs_support') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET support_link = ?, deposit_link = ?, room_link = ?, join_link = ?
    LIMIT 1
");
$stmt_update->bind_param("ssss", $support_link, $deposit_link, $room_link, $join_link);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "Link Update Successfully"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }
 
 if($rs_action == 'rs_update') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET vc = ?, update_link = ?, update_date = ?, update_notice = ?
    LIMIT 1
");
$stmt_update->bind_param("ssss", $vc, $update_link, $update_date, $update_notice);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "App Update Successfully"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }
 
 if($rs_action == 'rs_close_notice') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET close_notice = ?
    LIMIT 1
");
$stmt_update->bind_param("s", $close_notice);

if ($stmt_update->execute()) {
    echo json_encode([
        "status"  => "success",
        "message" => "Close Reason Update Successfully"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }
 
  if($rs_action == 'rs_status') {
 
 $stmt_update = $conn->prepare("
    UPDATE `setting` 
    SET app_status = ?
    LIMIT 1
");
$stmt_update->bind_param("s", $app_status);

    if ($stmt_update->execute()) {
    
        if($app_status == 'true') {
        echo json_encode([
                "status"  => "success",
                "message" => "On"
                    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        } else {
echo json_encode([
                "status"  => "success",
                "message" => "Off"
                    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
        }

} else {
    echo json_encode([
        "status"  => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}
 
 }

$stmt_update->close();
$conn->close();
?>