<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
include("../rs.php");

$sender = $_POST['sender'];
$message = $_POST['message'];
$admin_email = $_POST['email'];
$admin_password = $_POST['password'];


if (empty($sender) || empty($message)) {
    echo "Missing required fields";
    exit();
}

$admin_stmt = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$admin_stmt->bind_param("ss", $admin_email, $admin_password);
$admin_stmt->execute();
$admin_result = $admin_stmt->get_result();

if ($admin_result->num_rows === 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $admin_stmt->close();
    $conn->close();
    exit();
}
$admin_stmt->close();

$developer_rscaptain = "INSERT INTO rs_sms (sender, message) 
        VALUES (?, ?)";

$rs = $conn->prepare($developer_rscaptain);
$rs->bind_param("ss", $sender, $message);

if ($rs->execute()) {
    echo json_encode(array("status" => "success", "message" => "Sms Add Success"));
} else {
    echo "Sms Add Failed: " . $rs->error;
}

$rs->close();
$conn->close();
?>