<?php
header('Content-Type: application/json; charset=utf-8');

include("../rs.php"); 

$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$matchkey = $_POST['matchkey'] ?? '';

if (empty($email) || empty($password) || empty($matchkey)) {
    echo json_encode(["error" => "Access Denied"]);
    exit();
}


$user_check_sql = "SELECT 1 FROM admins WHERE email = ? AND password = ?";
$user_check_stmt = $conn->prepare($user_check_sql);
$user_check_stmt->bind_param("ss", $email, $password);
$user_check_stmt->execute();
$user_check_result = $user_check_stmt->get_result();

if ($user_check_result->num_rows == 0) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit();
}



$stmt = $conn->prepare("SELECT 1 FROM `match` WHERE matchkey = ?");
$stmt->bind_param("s", $matchkey);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(["error" => "Access Denied"]);
    exit();
}
$stmt->close();


$stmt = $conn->prepare("UPDATE `match` SET `status` = 'Result' WHERE matchkey = ?");
$stmt->bind_param("s", $matchkey);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Transfer Successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Access Denied"]);
}

$stmt->close();
$conn->close();
?>
