<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');


include("../rs.php");


$email = isset($_POST['email']) ? $_POST['email'] : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';
$action = isset($_POST['action']) ? $_POST['action'] : '';
$sliderImage = isset($_POST['image']) ? $_POST['image'] : '';
$link = isset($_POST['link']) ? $_POST['link'] : '';


$adminCheck = $conn->prepare("SELECT 1 FROM admins WHERE email = ? AND password = ?");
$adminCheck->bind_param("ss", $email, $password);
$adminCheck->execute();
$adminResult = $adminCheck->get_result();

if ($adminResult->num_rows === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
    $adminCheck->close();
    $conn->close();
    exit();
}

if ($action === 'add') {

    if (empty($sliderImage) || empty($link)) {
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
        $adminCheck->close();
        $conn->close();
        exit();
    }

    $insertSlider = $conn->prepare("INSERT INTO slider (image, link) VALUES (?, ?)");
    $insertSlider->bind_param("ss", $sliderImage, $link);

    if ($insertSlider->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Slider Added Successfully"
        ], JSON_PRETTY_PRINT);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
    }

    $insertSlider->close();

} elseif ($action === 'delete') {

    $sliderId = $_POST['id'];
    
        if (empty($sliderId)) {
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
        $adminCheck->close();
        $conn->close();
        exit();
    }
    
    $deleteSlider = $conn->prepare("DELETE FROM slider WHERE id = ?");
    $deleteSlider->bind_param("i", $sliderId);

    if ($deleteSlider->execute()) {
        if ($deleteSlider->affected_rows > 0) {
            echo json_encode([
                "status" => "success",
                "message" => "Deleted Successfully"
            ], JSON_PRETTY_PRINT);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Access Denied"
            ], JSON_PRETTY_PRINT);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Access Denied"
        ], JSON_PRETTY_PRINT);
    }

    $deleteSlider->close();

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT);
}

$adminCheck->close();
$conn->close();

?>
