<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";


include("../rs.php");

$provider = $_POST['provider'] ?? '';
$transaction_id = $_POST['transaction_id'] ?? '';
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$did = $_POST['did'] ?? '';
$time = date("d/m/Y h:i a");
$host = $_SERVER['HTTP_HOST'];

if (empty($provider) || empty($transaction_id) || empty($email) || empty($password) || empty($did)) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}



$stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND password = ? AND device_id = ? AND status = 'Unban'");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$user = $result->fetch_assoc();
$name = $user['name'];
$current_balance = intval($user['balance']);
$number = $user['number'];

$sms_sql = $conn->prepare("SELECT * FROM rs_sms WHERE sender = ? AND message LIKE ?");
$search_txn = "%$transaction_id%";
$sms_sql->bind_param("ss", $provider, $search_txn);
$sms_sql->execute();
$sms_result = $sms_sql->get_result();

$foundRow = null;
$found_txn_id = null;
$amount = 0.00;
$provider_up = strtoupper($provider);

if ($sms_result->num_rows === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Transaction Not Found"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

while ($row = $sms_result->fetch_assoc()) {
    $message = $row['message'];
    $candidate_txn = null;
    $candidate_amount = null;

    if ($provider_up === 'NAGAD') {
        if (preg_match('/TxnID[:\s]*([A-Z0-9]+)/i', $message, $m_txn)) {
            $candidate_txn = $m_txn[1];
        } elseif (preg_match('/Txn[:\s]*([A-Z0-9]+)/i', $message, $m_txn2)) {
            $candidate_txn = $m_txn2[1];
        }
        if (preg_match('/Amount[:\s]*Tk\s*([\d,\.]+)/i', $message, $m_amt)) {
            $candidate_amount = floatval(str_replace(',', '', $m_amt[1]));
        }
    } elseif ($provider_up === 'BKASH') {
        if (preg_match('/TrxID[:\s]*([A-Z0-9]+)/i', $message, $m_txn)) {
            $candidate_txn = $m_txn[1];
        } elseif (preg_match('/Trx[:\s]*([A-Z0-9]+)/i', $message, $m_txn2)) {
            $candidate_txn = $m_txn2[1];
        }
        if (preg_match('/You have received\s*Tk\s*([\d,\.]+)/i', $message, $m_amt)) {
            $candidate_amount = floatval(str_replace(',', '', $m_amt[1]));
        }
    }

    if ($candidate_txn !== null && strcasecmp($candidate_txn, $transaction_id) === 0) {
        $foundRow = $row;
        $found_txn_id = $candidate_txn;
        if ($candidate_amount !== null) $amount = $candidate_amount;
        break;
    }
}

if ($foundRow === null) {
    echo json_encode([
        "status" => "error",
        "message" => "Transaction Not Found"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

if ($foundRow['status'] === 'success') {
    echo json_encode([
        "status" => "error",
        "message" => "Transaction Id Already Used"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$min_sql = $conn->prepare("SELECT min_deposit FROM setting LIMIT 1");
$min_sql->execute();
$min_result = $min_sql->get_result();
$min_data = $min_result->fetch_assoc();
$min_balance = intval($min_data['min_deposit']);

if (floatval($amount) < $min_balance) {
    echo json_encode([
        "status" => "error",
        "message" => "Minimum Deposits ৳" . $min_balance
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}


$tranx_sql = $conn->prepare("SELECT * FROM tranx WHERE tranx = ?");
$tranx_sql->bind_param("s", $transaction_id);
$tranx_sql->execute();
$tranx_result = $tranx_sql->get_result();

if ($tranx_result->num_rows > 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Transaction Already Used"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$new_balance = $current_balance + floatval($amount);
$update_balance = $conn->prepare("UPDATE users SET balance = ? WHERE email = ? AND password = ?");
$update_balance->bind_param("dss", $new_balance, $email, $password);

if (!$update_balance->execute()) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$insert_sql = $conn->prepare("INSERT INTO tranx (name, number, method, email, password, tranx, amount, status, type, time) VALUES (?, ?, ?, ?, ?, ?, ?, 'Success', 'Deposit', ?)");
$insert_sql->bind_param("ssssssss", $name, $number, $provider, $email, $password, $transaction_id, $amount, $time);

if ($insert_sql->execute()) {

    $sms_row_id = $foundRow['id'];
    $update_sms = $conn->prepare("UPDATE rs_sms SET status = 'success' WHERE id = ?");
    $update_sms->bind_param("i", $sms_row_id);
    $update_sms->execute();

    echo json_encode([
        "status" => "success",
        "message" => "Deposit Success",
        "new_balance" => $new_balance,
        "tranx_id" => $transaction_id
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

    $rs_notice_api = $scheme . "://" . $host . "/notice_sender.php?"
        . "title=" . urlencode("Deposit Now,")
        . "&body=" . urlencode($name . "\n"
            . $number . "\n"
            . $email . "\n"
            . "Amount : " . $amount . "\n"
            . "Transaction Id : " . $transaction_id
        );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $rs_notice_api);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Rs_Debug_Token: Fucker558@@"
    ]);

    $rs_notice_response = curl_exec($ch);
    curl_close($ch);

} else {
    echo json_encode([
        "status" => "error",
        "message" => "Deposit Failed"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$conn->close();

?>