<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');

include("../rs.php");


if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $conn->close();
    exit();
}

$email    = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$did      = $_POST['did'] ?? '';

$stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ? AND device_id = ?");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result_user = $stmt->get_result();

if ($result_user->num_rows == 0) {
    http_response_code(403);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    $conn->close();
    exit();
}

$response = [];

    $stmt = $conn->prepare("SELECT id, title, time,	entry_fees,	win FROM `match_history` WHERE email = ? AND password = ? ORDER BY id DESC");
    $stmt->bind_param("ss", $email, $password);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $response[] = $row;
        }
    } else {
        echo "empty";
        $conn->close();
        exit();
    }


echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

$conn->close();
?>
