<?php
header('Content-Type: application/json; charset=UTF-8');

include("../rs.php");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


$email    = isset($_POST['email']) ? trim($_POST['email']) : null;
$password = isset($_POST['password']) ? trim($_POST['password']) : null;
$did      = isset($_POST['did']) ? trim($_POST['did']) : null;


$missing = [];
if (empty($email)) $missing[] = 'email';
if (empty($password)) $missing[] = 'password';
if (empty($did)) $missing[] = 'did';

if (!empty($missing)) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


if (strlen($email) > 90 || strlen($password) > 50 || strlen($did) > 100) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}


$user_stmt = $conn->prepare("SELECT id, balance, winning FROM users WHERE email = ? AND password = ? AND device_id = ? LIMIT 1");
if (!$user_stmt) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}
$user_stmt->bind_param("sss", $email, $password, $did);
$user_stmt->execute();
$user_result = $user_stmt->get_result();

if (!$user_result || $user_result->num_rows === 0) {
    $user_stmt->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$user_row = $user_result->fetch_assoc();
$user_id  = $user_row['id'];
$balance  = $user_row['balance'];
$winning  = $user_row['winning'];
$user_stmt->close();


$setting_stmt = $conn->prepare("
    SELECT deposit_link, room_link, join_link
    FROM setting
    LIMIT 1
");
if (!$setting_stmt) {
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}
$setting_stmt->execute();
$setting_result = $setting_stmt->get_result();

if (!$setting_result || $setting_result->num_rows === 0) {
    $setting_stmt->close();
    echo json_encode(["status" => "error", "message" => "Access Denied"], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    exit;
}

$setting = $setting_result->fetch_assoc();
$setting_stmt->close();

$response = [
    
    "balance"       => $balance,
    "winning"       => $winning,
    "deposit_link"  => $setting['deposit_link'],
    "room_link"            => $setting['room_link'],
    "join_link"     => $setting['join_link']
    
];

echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
exit;

$conn->close();
?>
