<?php

header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('Asia/Dhaka');
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}



include("../rs.php");

$provider = $_POST['provider'] ?? '';
$amount = $_POST['amount'] ?? '';
$number = $_POST['number'] ?? '';
$email = $_POST['email'] ?? '';
$password = $_POST['password'] ?? '';
$did = $_POST['did'] ?? '';
$time = date("d/m/Y h:i a");
$host = $_SERVER['HTTP_HOST'];

if (empty($provider) || empty($amount) || empty($number) || empty($email) || empty($password) || empty($did)) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

if (!is_numeric($amount) || floatval($amount) <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid Amount"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}


$stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND password = ? AND device_id = ? AND `status` = 'Unban'");
$stmt->bind_param("sss", $email, $password, $did);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$user = $result->fetch_assoc();
$name = $user['name'];
$current_winning_balance = intval($user['winning']);


$min_sql = $conn->prepare("SELECT min_withdraw FROM setting LIMIT 1");
$min_sql->execute();
$min_result = $min_sql->get_result();
$min_data = $min_result->fetch_assoc();
$min_withdraw = intval($min_data['min_withdraw']);

if (floatval($amount) < $min_withdraw) {
    echo json_encode([
        "status" => "error",
        "message" => "Minimum Withdraw ৳" . $min_withdraw
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

if ($current_winning_balance < floatval($amount)) {
    echo json_encode([
        "status" => "error",
        "message" => "Insufficient Winning Balance"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$transaction_id = strtoupper(uniqid('WD-'));

$new_winning_balance = $current_winning_balance - floatval($amount);
$update_balance = $conn->prepare("UPDATE users SET winning = ? WHERE email = ? AND password = ?");
$update_balance->bind_param("dss", $new_winning_balance, $email, $password);

if (!$update_balance->execute()) {
    echo json_encode([
        "status" => "error",
        "message" => "Access Denied"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    exit();
}

$insert_sql = $conn->prepare("INSERT INTO tranx (name, number, method, email, password, tranx, amount, status, type, time) VALUES (?, ?, ?, ?, ?, ?, ?, 'Pending', 'Withdraw', ?)");
$insert_sql->bind_param("ssssssds", $name, $number, $provider, $email, $password, $transaction_id, $amount, $time);

if ($insert_sql->execute()) {
    echo json_encode([
        "status"        => "success",
        "message"       => "Request Success",
        "new_w_balance" => $new_winning_balance,
        "tranx_id"      => $transaction_id
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
    
    $rs_notice_api = $scheme . "://" . $host . "/notice_sender.php?"
    . "title=" . urlencode("Withdraw Request,")
    . "&body=" . urlencode($name . "\n" 
        . $number . "\n" 
        . $email . "\n" 
        . "Amount : " . $amount
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $rs_notice_api);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Rs_Debug_Token: Fucker558@@"
    ]);

    $rs_notice_response = curl_exec($ch);
    curl_close($ch);

    
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Request Failed"
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
}

$conn->close();

?>
